import _extends from "@babel/runtime/helpers/esm/extends";
import * as React from 'react';
import PropTypes from 'prop-types';
import { forwardRef } from '@mui/x-internals/forwardRef';
import { useGridSelector } from "../hooks/utils/useGridSelector.js";
import { gridTopLevelRowCountSelector } from "../hooks/features/rows/gridRowsSelector.js";
import { gridRowSelectionCountSelector } from "../hooks/features/rowSelection/gridRowSelectionSelector.js";
import { gridFilteredTopLevelRowCountSelector } from "../hooks/features/filter/gridFilterSelector.js";
import { useGridApiContext } from "../hooks/utils/useGridApiContext.js";
import { GridSelectedRowCount } from "./GridSelectedRowCount.js";
import { GridFooterContainer } from "./containers/GridFooterContainer.js";
import { useGridRootProps } from "../hooks/utils/useGridRootProps.js";
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
const GridFooter = forwardRef(function GridFooter(props, ref) {
  const apiRef = useGridApiContext();
  const rootProps = useGridRootProps();
  const totalTopLevelRowCount = useGridSelector(apiRef, gridTopLevelRowCountSelector);
  const selectedRowCount = useGridSelector(apiRef, gridRowSelectionCountSelector);
  const visibleTopLevelRowCount = useGridSelector(apiRef, gridFilteredTopLevelRowCountSelector);
  const selectedRowCountElement = !rootProps.hideFooterSelectedRowCount && selectedRowCount > 0 ? /*#__PURE__*/_jsx(GridSelectedRowCount, {
    selectedRowCount: selectedRowCount
  }) : /*#__PURE__*/_jsx("div", {});
  const rowCountElement = !rootProps.hideFooterRowCount && !rootProps.pagination ? /*#__PURE__*/_jsx(rootProps.slots.footerRowCount, _extends({}, rootProps.slotProps?.footerRowCount, {
    rowCount: totalTopLevelRowCount,
    visibleRowCount: visibleTopLevelRowCount
  })) : null;
  const paginationElement = rootProps.pagination && !rootProps.hideFooterPagination && rootProps.slots.pagination && /*#__PURE__*/_jsx(rootProps.slots.pagination, {});
  return /*#__PURE__*/_jsxs(GridFooterContainer, _extends({}, props, {
    ref: ref,
    children: [selectedRowCountElement, rowCountElement, paginationElement]
  }));
});
if (process.env.NODE_ENV !== "production") GridFooter.displayName = "GridFooter";
process.env.NODE_ENV !== "production" ? GridFooter.propTypes = {
  // ----------------------------- Warning --------------------------------
  // | These PropTypes are generated from the TypeScript type definitions |
  // | To update them edit the TypeScript types and run "pnpm proptypes"  |
  // ----------------------------------------------------------------------
  sx: PropTypes.oneOfType([PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.func, PropTypes.object, PropTypes.bool])), PropTypes.func, PropTypes.object])
} : void 0;
export { GridFooter };